CREATE FUNCTION [dbo].[NumerFaktury_Wyodrebnij]
(
    @cFaktura NVARCHAR(30),
    @cSeek NVARCHAR,
    @cFormat NVARCHAR(30)
)
RETURNS NVARCHAR(30)
AS
BEGIN
    DECLARE @cValue NVARCHAR(30);
    DECLARE @n INT;
    DECLARE @m INT;
    DECLARE @nInFormatAt INT;
    DECLARE @nRok INT;
    DECLARE @cFormatUpper NVARCHAR(30);

    SET @cFormat = RTrim(LTrim(@cFormat));
    SET @cFaktura = RTrim(LTrim(@cFaktura));
    SET @cValue = '';
    SET @cFormatUpper = Upper(@cFormat);

    SET @n = 1;
    SET @m = 1;

    SET @nInFormatAt = 0;
    IF @cSeek = 'Y'
    BEGIN
        SET @nInFormatAt = CHARINDEX('YYYY', @cFormatUpper);
        IF @nInFormatAt = 0
        BEGIN
            SET @nInFormatAt = CHARINDEX('YY', @cFormatUpper);
        END;
    END;
    IF @cSeek = 'R'
    BEGIN
        SET @nInFormatAt = CHARINDEX('RRRR', @cFormatUpper);
        IF @nInFormatAt = 0
        BEGIN
            SET @nInFormatAt = CHARINDEX('RR', @cFormatUpper);
        END;
    END;
    IF @cSeek = 'C'
    BEGIN
        SET @nInFormatAt = CHARINDEX('CCCCCCCCC', @cFormatUpper);
    END;
    IF @cSeek = 'M'
    BEGIN
        SET @nInFormatAt = CHARINDEX('MM', @cFormatUpper);
    END;
    IF @cSeek = 'N'
    BEGIN
        SET @nInFormatAt = CHARINDEX('NNNNN', @cFormatUpper);
        IF @nInFormatAt = 0
        BEGIN
            SET @nInFormatAt = CHARINDEX('NNNN', @cFormatUpper);
        END;
        IF @nInFormatAt = 0
        BEGIN
            SET @nInFormatAt = CHARINDEX('NNN', @cFormatUpper);
        END;
        IF @nInFormatAt = 0
        BEGIN
            SET @nInFormatAt = CHARINDEX('NN', @cFormatUpper);
        END;
    END;    

    WHILE @m <= Len(@cFaktura)
    BEGIN
        
        IF SubString(@cFaktura, @m, 1) = '/' OR SubString(@cFaktura, @m, 1) = '-'
        BEGIN
              WHILE @n <= Len(@cFormat) AND NOT(SubString(@cFormat, @n, 1) = '/' OR SubString(@cFormat, @n, 1) = '-')
              BEGIN
                    SET @n = @n + 1;
              END;
              
              IF @cValue != '' AND @cSeek = 'C'
              BEGIN
                  BREAK;
              END;
        END
        ELSE IF Upper(SubString(@cFormat, @n, 1)) = @cSeek
        BEGIN
            IF @n = @nInFormatAt
            BEGIN
                SET @cValue = @cValue + SubString(@cFaktura, @m, 1);
                SET @nInFormatAt = @nInFormatAt + 1;
            END
            ELSE IF @nInFormatAt = 0
            BEGIN
                SET @cValue = @cValue + SubString(@cFaktura, @m, 1);
            END;
        END;
        
        SET @n = @n + 1;
        
        IF @n > Len(@cFormat)
        BEGIN
            SET @m = Len(@cFaktura);
        END;
        
        SET @m = @m + 1;
    END;

    IF @cSeek = 'R' AND (Len(@cValue) = 1 OR Len(@cValue) = 2)
    BEGIN
        SET @cValue = '20' + @cValue
    END;
    
    RETURN @cValue;
END;
